﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SampleDomain
{
    public class Loan
    {
        public double CalculateMonthlyPayment(
            int yearsForPayments,
            double interestRate,
            int loanAmount)
        {
            int monthsForPayments = yearsForPayments * 12;

            double interestRateAsNumber = interestRate / 100;

            double periodicInterestRate = interestRateAsNumber / 12;

            double x = Math.Pow((1 + periodicInterestRate), monthsForPayments);

            double discountFactor = (x - 1) / (periodicInterestRate * x);

            double monthlyPayment = loanAmount / discountFactor;

            return monthlyPayment;
        }
    }
}