﻿using NUnit.Framework;
using SampleDomain;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SampleDomainUnitTests
{
    [TestFixture]
    public class LoanShould
    {
        [Test]
        [TestCase(30, 6, 100000, 599.55)]
        public void CalculateMonthlyPayment(
            int yearsForPayments,
            double interestRate,
            int loanAmount,
            double expectedMonthlyPayment)
        {
            // Arrange
            Loan sut = new Loan();

            // Act
            double actualMonthlyPayment = sut.CalculateMonthlyPayment(
                yearsForPayments,
                interestRate,
                loanAmount);

            // Assert
            Assert.AreEqual(expectedMonthlyPayment, Math.Round(actualMonthlyPayment, 2));
        }
    }
}